#include <bits/stdc++.h>
using namespace std;
struct TrieNode {
    map<char, TrieNode*> children;
    vector<long long> numbers;
};

void insert(TrieNode* root, const string& s, long long num) {
    TrieNode* node = root;
    for (char c : s) {
        if (!node->children.count(c)) {
            node->children[c] = new TrieNode();
        }
        node = node->children[c];
    }
    node->numbers.push_back(num);
}
void collect(TrieNode* node, vector<vector<long long>>& ans) {
    if (!node) return;
    vector<long long> subset;
    for (auto& [_, child] : node->children) {
        collect(child, ans);
    }
    for (long long x : node->numbers) subset.push_back(x);
    if (!subset.empty()) ans.push_back(subset);
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<long long> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i];
    TrieNode* root = new TrieNode();
    for (long long x : a) {
        insert(root, to_string(x), x);
    }
    vector<vector<long long>> ans;
    collect(root, ans);
    cout << ans.size() << "\n";
    for (auto &subset : ans) {
        cout << subset.size() << "\n";
        for (long long x : subset) cout << x << " ";
        cout << "\n";
    }
    return 0;
}